/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.DictionaryDialog;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.DictionaryDialog.DictionaryDialogController;
import net.nooj4nlp.engine.Dictionary;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Preferences;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class InflectActionListener
implements ActionListener,
PropertyChangeListener {
    private DictionaryDialogController controller;

    public InflectActionListener(DictionaryDialogController controller) {
        this.controller = controller;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            Launcher.getStatusBar().getProgressBar().setIndeterminate(false);
            Launcher.getStatusBar().getProgressBar().setValue(progress);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String languagename;
        String fullName = this.controller.getTxtDictionaryName().getText();
        if (fullName.equals("")) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Filename should not be empty", "NooJ", 1);
            return;
        }
        File file = new File(fullName);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find file " + fullName, "NooJ: cannot find dictionary file", 1);
            return;
        }
        String fName = FilenameUtils.removeExtension(FilenameUtils.getName(fullName));
        String dirName = FilenameUtils.getFullPath(fullName);
        String resName = dirName + fName + "-flx.dic";
        try {
            languagename = Dictionary.getLanguage(fullName);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary has not a valid format.", "NooJ: cannot read dictionary language", 1);
            return;
        }
        this.controller.lan = new Language(languagename);
        this.dictionaryInflect(fullName, resName, this.controller.getChckbxCheckAgreement().isSelected(), this.controller.lan, Launcher.preferences);
    }

    private void dictionaryInflect(String fullName, String resName, boolean checkAgreement, Language lan, Preferences preferences) {
        if (Launcher.backgroundWorking) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "One process is already running.", "NooJ: one process only in this version", 0);
            return;
        }
        Launcher.initialDate = new Date();
        this.controller.desactivateOps();
        Launcher.getStatusBar().getBtnCancel().setEnabled(true);
        Launcher.getStatusBar().getBtnCancel().setForeground(Color.red);
        Launcher.progressMessage = "Inflect dictionary...";
        Launcher.getStatusBar().getProgressLabel().setText("Inflect dictionary...");
        Launcher.backgroundWorking = true;
        Launcher.checkAgreement = checkAgreement;
        Launcher.backgroundWorker = new BackgroundWorker("dic inflect", null, this.controller);
        Launcher.backgroundWorker.addPropertyChangeListener(this);
        Launcher.backgroundWorker.execute();
        try {
            Dictionary.inflect(fullName, resName, checkAgreement, lan, preferences);
            this.controller.reactivateOps();
            Date now = new Date();
            long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
            Launcher.getStatusBar().getProgressLabel().setText(Long.toString(sec) + " sec");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
        }
    }
}

